// DeleteAccessLevel.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "DeleteAccessLevel.h"
#include <afxtempl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDeleteAccessLevel dialog


CDeleteAccessLevel::CDeleteAccessLevel(CWnd* pParent /*=NULL*/)
	: CDialog(CDeleteAccessLevel::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDeleteAccessLevel)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CDeleteAccessLevel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDeleteAccessLevel)
	DDX_Control(pDX, ID_REASSIGN, m_BtnReassign);
	DDX_Control(pDX, IDC_REASSIG_ACCLLIST, m_Reassign_AcclList);
	DDX_Control(pDX, IDC_ASSOCIATE_CARDS, m_assciateCards);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Control(pDX, IDC_ACCLLIST, m_AcclList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDeleteAccessLevel, CDialog)
	//{{AFX_MSG_MAP(CDeleteAccessLevel)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(ID_DELETE, OnDelete)
	ON_BN_CLICKED(ID_ISOLATE, OnIsolate)
	ON_CBN_SELCHANGE(IDC_ACCLLIST, OnSelchangeAccllist)
	ON_BN_CLICKED(ID_REASSIGN, OnReassign)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDeleteAccessLevel message handlers
BOOL CDeleteAccessLevel::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
	m_BtnReassign.EnableWindow(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
CDeleteAccessLevel ::CDeleteAccessLevel(IApplication *pApp):CDialog(CDeleteAccessLevel::IDD, NULL)
{
	pApplication = pApp;
}
void CDeleteAccessLevel :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release(); 
		}
	UpdateData(FALSE);
//	m_AcctList.SetCurSel(0);
}

void CDeleteAccessLevel :: LoadSubAccounts(long lAcctID)
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
		pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get subaccount details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pSubAccount = NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount != NULL)
			{
				m_SubAcctList.AddString(pSubAccount->AccountName);
				pSubAccount->Release();
			}
			pDisp->Release(); 
		}
	UpdateData(FALSE);
//	m_AcctList.SetCurSel(0);
}

void CDeleteAccessLevel ::LoadAccessLevels()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

		//select subaccount name 
		int subacct_index = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(subacct_index,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vAccls;
		vAccls.Clear();
		pApplication->GetAccessLevelsByAccountName(bstrAcctName,bstrSubAcctName,&vAccls); // get access levels details of particular account  in WP-CS database server
		
		if(vAccls.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccessLevel *pAccl = NULL;
		
		COleSafeArray sa(vAccls);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccessLevel,(void**)&pAccl);
			if (pAccl != NULL)
			{
				m_AcclList.AddString(pAccl->AccessLevelName);
				pAccl->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_AcclList.SetCurSel(0);
}
void CDeleteAccessLevel::OnSelchangeAcctlist() 
{
	int index_Acct = m_AcctList.GetCurSel();
	CString sAcctid;

	m_AcctList.GetLBText(index_Acct,sAcctid);
	long lAccountID = _wtoi(sAcctid);

	/*m_assciateCards.ResetContent();
	m_AcclList.ResetContent();
	LoadAccessLevels();
	m_Reassign_AcclList.ResetContent();
	LoadReassignAccessLevels();*/

	m_SubAcctList.ResetContent();
	LoadSubAccounts(lAccountID);
	
}

void CDeleteAccessLevel::OnSelchangeSubAcctlist() 
{
	m_assciateCards.ResetContent();
	m_AcclList.ResetContent();
	LoadAccessLevels();
	m_Reassign_AcclList.ResetContent();
	LoadReassignAccessLevels();
	
}

void CDeleteAccessLevel::OnDelete() 
{
		BSTR bstrAcctName;
		BSTR bstrAcclName;

		UpdateData(TRUE);
	//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
		
	//select access level List
		int index_Accl = m_AcclList.GetCurSel();
		CString sAcclName;
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			m_AcclList.GetLBText(index_Accl,sAcclName);
			bstrAcclName = sAcclName.AllocSysString();
		}
		//delete the access level
		long lstatus;
		pApplication->DeleteAccessLevel(bstrAcclName,bstrAcctName,&lstatus);
		
		if (lstatus == 201)
		{
			AfxMessageBox(L"InValid access Level Name");
			return;
		}
		if (lstatus == 203)
		{

			AfxMessageBox(L"Access Level Associated with Card");
			return;
		}
		if ( lstatus == 1)
		{
			AfxMessageBox(L"Access Level Deletion Failed");
			return;	
		}
		else
		{
			AfxMessageBox(L"Access Level Deletion Succeded");
			CDialog::OnOK();
		}
}

void CDeleteAccessLevel::OnIsolate() 
{
	
	m_assciateCards.ResetContent();
	m_BtnReassign.EnableWindow(TRUE);

	//select account name 
	int index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);


	BSTR bstrAcclName;
	//select access level List
	int index_Accl = m_AcclList.GetCurSel();
	CString sAcclName;
	if (index_Accl <0)
		bstrAcclName = SysAllocString(L"");
	else
	{
		m_AcclList.GetLBText(index_Accl,sAcclName);
		bstrAcclName = sAcclName.AllocSysString();
	}
	//BSTR bstrAcclName =SysAllocString(L"Access1");
	_variant_t vcards;
	vcards.Clear();
	long lStatus;
	pApplication->IsolateAccessLevel(bstrAcclName,bstrAcctName,&vcards,&lStatus);
		
		if ( lStatus == 201)
		{
			AfxMessageBox(L"Invalid Access Level Name");
			return;
		}
		else
		{
			if(vcards.vt == VT_EMPTY || vcards.parray->rgsabound->cElements == 0)
			{
				AfxMessageBox(L"No Cards Associated");
				return;
			}
			
			long uBound =0 ;
			
			COleSafeArray sa(vcards);
			sa.GetUBound(1,&uBound);
			UpdateData(TRUE);
			BSTR sCardno;
			for(long i =0 ;i <= uBound ; i++)
			{
				sa.GetElement(&i,(void*)&sCardno);
				CString scard = CString(sCardno);
				//AfxMessageBox(scard);
				m_assciateCards.AddString(scard);
			}
		}
}

void CDeleteAccessLevel::OnSelchangeAccllist() 
{
	m_BtnReassign.EnableWindow(FALSE);
	m_assciateCards.ResetContent();
	m_Reassign_AcclList.ResetContent();
	LoadReassignAccessLevels();

}
void CDeleteAccessLevel::LoadReassignAccessLevels()
{
	
	//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
		
		//select access level 
		BSTR bstrAcclName;
		int index_Accl = m_AcclList.GetCurSel();
		CString sAcclName;
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			m_AcclList.GetLBText(index_Accl,sAcclName);
			bstrAcclName = sAcclName.AllocSysString();
		}

		_variant_t vReassign_Accls;
		vReassign_Accls.Clear();
		pApplication->GetAccesslevelsForReassign(bstrAcctName,bstrAcclName,&vReassign_Accls);
		
		if(vReassign_Accls.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccessLevel *pAccl = NULL;
		
		COleSafeArray sa(vReassign_Accls);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccessLevel,(void**)&pAccl);
			if (pAccl != NULL)
			{
				m_Reassign_AcclList.AddString(pAccl->AccessLevelName);
				pAccl->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_Reassign_AcclList.SetCurSel(0);	
}

void CDeleteAccessLevel::OnReassign() 
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
	
		//select access level 
		BSTR bstrAcclName;
		int index_Accl = m_AcclList.GetCurSel();
		CString sAcclName;
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			m_AcclList.GetLBText(index_Accl,sAcclName);
			bstrAcclName = sAcclName.AllocSysString();
		}

		//select access level to reassign
		BSTR bstrReassignAcclName;
		int index_ReassignAccl = m_Reassign_AcclList.GetCurSel();
		CString sReassignAcclName;
		if (index_ReassignAccl <0)
			bstrReassignAcclName = SysAllocString(L"");
		else
		{
			m_Reassign_AcclList.GetLBText(index_ReassignAccl,sReassignAcclName);
			bstrReassignAcclName = sReassignAcclName.AllocSysString();
		}
	// select the cards from card list
		COleSafeArray saCards;
		_bstr_t bstrcardno;
		VARIANT vCards;
		CArray<int,int> sels; //selected cards list template

		 int n = m_assciateCards.GetSelCount();
		
		 if(n <= 0)
		 {
			 AfxMessageBox(L"Select Atleast one Card");
		 	return; // nothing to copy
		 }
		
		 saCards.CreateOneDim(VT_BSTR,n);
		 sels.SetSize(n);
		 
		 m_assciateCards.GetSelItems(n, sels.GetData());

		 //*****************************************************************************
		 // This segment of code only works if the listbox is non-owner-draw,          *
		 // or is owner-draw with LBS_HASSTRINGS                                       *
		 // So first check to make sure this is true                                   *
		 //*****************************************************************************
		 ASSERT( (GetStyle() & (LBS_OWNERDRAWFIXED | LBS_OWNERDRAWVARIABLE)) == 0 || //*
				 (GetStyle() & LBS_HASSTRINGS) == LBS_HASSTRINGS);                   //*
																					 //*
		 // Extract the text and put it to safe array;                                                        
		for(long i = 0; i < n; i++)                                                  
		{                                                      
			CString t;                                                              
			m_assciateCards.GetText(sels[i], t);
			bstrcardno = t.AllocSysString();
			saCards.PutElement(&i,static_cast<BSTR>(bstrcardno));
		 } 
		 vCards = saCards.Detach();
		 long lStatus;
		 //Reassign the access level
		 pApplication->ReassignAccessLevel(bstrAcctName,bstrAcclName,bstrReassignAcclName,vCards,&lStatus);

		 if(lStatus == 201)
		 {
			 AfxMessageBox(L"Invalid Access level Name");
			return;
		 }
		 if(lStatus == 105)
		 {
			 AfxMessageBox(L"Invalid Account");
			 return;
		 }
		if(lStatus == 204)
		{
			AfxMessageBox(L"Atleast Select One Card to Reassign");
			 return;
		}
		if(lStatus == 1)
		{
			AfxMessageBox(L"Access level Reassign Failed");
			 return;
		}
		else
		{
			AfxMessageBox(L"Access level Reassign Succeded");
		}
			

	}	




